
CREATE OR REPLACE FUNCTION abk__a_d__resource_delete()
  RETURNS TRIGGER AS $$

  DECLARE

      _prefix varchar := 'TRIGGER abk__a_d__resource_delete -';
      _loglevel integer := TSystem.Log_Get_LogLevel( _user => 'yes' );

  BEGIN

      -- Debug
      IF _loglevel >= 5 THEN
          RAISE NOTICE '% ab_ix:%;', _prefix, old.ab_ix;
      END IF;

      -- ABK-Ressource löschen.
      DELETE FROM scheduling.resource
      WHERE context = 'abk'
        AND context_id = old.ab_ix;

      RETURN old;

  END $$ LANGUAGE plpgsql;
--
DROP TRIGGER IF EXISTS abk__a_d__resource_delete ON public.abk;
CREATE TRIGGER abk__a_d__resource_delete
  AFTER DELETE
  ON abk
  FOR EACH ROW
  EXECUTE PROCEDURE abk__a_d__resource_delete();
